/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class PlotPanel
extends Panel
implements MouseListener {
    static double a = 1.0;
    static double b = 1.0;
    static double c = 0.0;
    static double d = 0.0;
    static double base = 2.0;
    double xTrace = 0.0;
    double yTrace = 0.0;
    int Ix = 50;
    int Iy = 50;
    static double xscale = 1.0;
    static double yscale = 1.0;
    private int width;
    private int height;
    private int halfw;
    private int halfh;
    Image image;
    static boolean flagClicks = true;
    static int functionNumber = 0;
    int w;
    int h;
    static int flagPlotPoints = -1;
    static double[] xpoint = new double[200];
    static double[] ypoint = new double[200];
    static int[] xpixpoint = new int[200];
    static int[] ypixpoint = new int[200];
    static int deleteFlag = 0;

    public PlotPanel(int n, int n2) {
        this.width = 4 * n / 5;
        this.height = 4 * n2 / 6;
        this.halfw = this.width / 2;
        this.halfh = this.height / 2;
        this.setSize(this.width, this.height);
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        this.image = this.createImage(this.width, this.height);
        Graphics graphics2 = this.image.getGraphics();
        this.drawAxis(graphics2);
        this.drawGrid(graphics2);
        this.drawGraph(graphics2);
        this.drawPoint(graphics2);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void drawAxis(Graphics graphics) {
        this.width = this.width;
        this.height = this.height;
        this.halfw = this.width / 2;
        this.halfh = this.height / 2;
        this.w = this.halfw / 50;
        this.h = this.halfh / 50;
        graphics.setColor(new Color(215, 250, 255));
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, this.width, 0);
        graphics.drawLine(1, 1, this.width - 1, 1);
        graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
        graphics.drawLine(this.width, 0, this.width, this.height);
        graphics.drawLine(this.width, this.height, 0, this.height);
        graphics.drawLine(this.width - 1, this.height - 1, 1, this.height - 1);
        graphics.drawLine(0, this.height, 0, 0);
        graphics.drawLine(1, this.height - 1, 1, 1);
        graphics.drawLine(0, this.halfh, this.width, this.halfh);
        graphics.drawLine(0, this.halfh + 1, this.width, this.halfh + 1);
        graphics.drawLine(this.halfw, 0, this.halfw, this.height);
        graphics.drawLine(this.halfw + 1, 0, this.halfw + 1, this.height);
    }

    public void drawGrid(Graphics graphics) {
        String string;
        graphics.setColor(Color.lightGray);
        int n = 1;
        while (n < this.w + 1) {
            graphics.drawLine(this.halfw + 50 * n, 0, this.halfw + 50 * n, this.height);
            graphics.drawLine(this.halfw - 50 * n, 0, this.halfw - 50 * n, this.height);
            ++n;
        }
        int n2 = 1;
        while (n2 < this.h + 1) {
            graphics.drawLine(0, this.halfh + 50 * n2, this.width, this.halfh + 50 * n2);
            graphics.drawLine(0, this.halfh - 50 * n2, this.width, this.halfh - 50 * n2);
            ++n2;
        }
        graphics.setColor(Color.black);
        int n3 = 1;
        while (n3 < this.w + 1) {
            graphics.drawLine(this.halfw + 50 * n3, this.halfh, this.halfw + 50 * n3, this.halfh + 5);
            String string2 = new Double(xscale * (double)n3).toString();
            graphics.drawString(string2, this.halfw + 50 * n3 - 5, this.halfh + 15);
            graphics.drawLine(this.halfw - 50 * n3, this.halfh, this.halfw - 50 * n3, this.halfh + 5);
            string = new Double(-xscale * (double)n3).toString();
            graphics.drawString(string, this.halfw - 50 * n3 - 5, this.halfh + 15);
            ++n3;
        }
        graphics.setColor(Color.black);
        int n4 = 1;
        while (n4 < this.h + 1) {
            graphics.drawLine(this.halfw, this.halfh - 50 * n4, this.halfw - 5, this.halfh - 50 * n4);
            string = new Double(yscale * (double)n4).toString();
            graphics.drawString(string, this.halfw - 20, this.halfh - 50 * n4);
            graphics.drawLine(this.halfw, this.halfh + 50 * n4, this.halfw - 5, this.halfh + 50 * n4);
            String string3 = new Double(-yscale * (double)n4).toString();
            graphics.drawString(string3, this.halfw - 20, this.halfh + 50 * n4);
            ++n4;
        }
    }

    public void drawPoint(Graphics graphics) {
        if (flagPlotPoints < 0) {
            return;
        }
        graphics.setColor(Color.red);
        int n = 0;
        while (n <= flagPlotPoints) {
            PlotPanel.xpixpoint[n] = this.halfw + (int)((double)this.Ix * xpoint[n] / xscale);
            PlotPanel.ypixpoint[n] = this.halfh - (int)((double)this.Iy * ypoint[n] / yscale);
            graphics.fillOval(xpixpoint[n] - 4, ypixpoint[n] - 4, 8, 8);
            ++n;
        }
    }

    public void drawGraph(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = this.halfw;
        int n5 = this.halfh;
        int n6 = this.halfw;
        int n7 = this.halfh;
        double d = 0.0;
        float f = this.Ix;
        float f2 = this.Iy;
        double d2 = 0.0;
        if (b > 0.0) {
            graphics.setColor(Color.blue);
            d = -c;
            n3 = this.halfw + (int)(d * (double)f / xscale) + 1;
            d = (double)(n3 - this.halfw) * xscale / (double)f;
            d2 = a * Math.log(b * (d + c)) / Math.log(base) + PlotPanel.d;
            n2 = this.halfh - (int)((double)f2 * d2 / yscale);
            n6 = n3;
            n7 = n2;
            n = n3;
            while (n <= this.width) {
                n4 = n6;
                n5 = n7;
                d = xscale * (double)(n - this.halfw) / (double)f;
                n6 = n;
                d2 = a * Math.log(b * (d + c)) / Math.log(base) + PlotPanel.d;
                n7 = this.halfh - (int)((double)f2 * (d2 / yscale));
                if (n7 < this.height & n7 >= 0) {
                    graphics.drawLine(n4, n5, n6, n7);
                    graphics.drawLine(n4 + 1, n5, n6 + 1, n7);
                }
                ++n;
            }
        }
        if (b < 0.0) {
            graphics.setColor(Color.blue);
            d = -c;
            n2 = n3 = this.halfw + (int)(d * (double)f / xscale) - 1;
            n3 = 0;
            d = (double)(n3 - this.halfw) * xscale / (double)f;
            d2 = a * Math.log(b * (d + c)) / Math.log(base) + PlotPanel.d;
            n = this.halfh - (int)((double)f2 * d2 / yscale);
            n6 = n3;
            n7 = n;
            int n8 = 0;
            while (n8 <= n2) {
                n4 = n6;
                n5 = n7;
                d = xscale * (double)(n8 - this.halfw) / (double)f;
                n6 = n8;
                d2 = a * Math.log(b * (d + c)) / Math.log(base) + PlotPanel.d;
                n7 = this.halfh - (int)((double)f2 * (d2 / yscale));
                if (n7 < this.height & n7 >= 0) {
                    graphics.drawLine(n4, n5, n6, n7);
                    graphics.drawLine(n4 + 1, n5, n6 + 1, n7);
                }
                ++n8;
            }
        }
        if (b == 0.0) {
            Font font = new Font("Dialog", 1, 20);
            graphics.setFont(font);
            graphics.setColor(Color.red);
            graphics.drawString(" b cannot be zero ", 50, 200);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (deleteFlag == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 <= flagPlotPoints) {
            int n3 = Math.abs(xpixpoint[n2] - mouseEvent.getX());
            int n4 = Math.abs(ypixpoint[n2] - mouseEvent.getY());
            n = n2;
            if (n3 <= 5 && n4 <= 5) {
                --flagPlotPoints;
                break;
            }
            ++n2;
        }
        int n5 = n;
        while (n5 <= flagPlotPoints) {
            PlotPanel.xpoint[n5] = xpoint[n5 + 1];
            PlotPanel.ypoint[n5] = ypoint[n5 + 1];
            ++n5;
        }
        PlotFrame.plotPanel.repaint();
        deleteFlag = 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

