/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class PlotPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    static double a = 1.0;
    static double b = 1.0;
    static double c = 0.0;
    static double slope;
    int flag = 0;
    int[] xpoint = new int[2];
    int[] ypoint = new int[2];
    double xTrace = 0.0;
    double yTrace = 0.0;
    static int Ix;
    static int Iy;
    static double xscale;
    static double yscale;
    static int width;
    static int height;
    static int halfw;
    static int halfh;
    Image image;
    static int xpointA;
    int ypointA;
    double xpointa;
    double ypointa;
    double xpointb;
    double ypointb;
    int w;
    int h;
    static int xpointB;
    int ypointB;

    public PlotPanel(int n, int n2) {
        width = 4 * n / 5;
        height = 4 * n2 / 6;
        halfw = width / 2;
        this.ypointA = halfh = height / 2;
        this.ypointB = halfh;
        this.setSize(width, height);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        width = dimension.width;
        height = dimension.height;
        this.image = this.createImage(width, height);
        Graphics graphics2 = this.image.getGraphics();
        this.drawAxis(graphics2);
        this.drawGrid(graphics2);
        this.drawGraph(graphics2);
        this.drawPoint(graphics2);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void drawAxis(Graphics graphics) {
        halfw = width / 2;
        halfh = height / 2;
        this.w = halfw / 50;
        this.h = halfh / 50;
        graphics.setColor(new Color(215, 250, 255));
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, width, 0);
        graphics.drawLine(1, 1, width - 1, 1);
        graphics.drawLine(width - 1, 1, width - 1, height - 1);
        graphics.drawLine(width, 0, width, height);
        graphics.drawLine(width, height, 0, height);
        graphics.drawLine(width - 1, height - 1, 1, height - 1);
        graphics.drawLine(0, height, 0, 0);
        graphics.drawLine(1, height - 1, 1, 1);
        graphics.drawLine(0, halfh, width, halfh);
        graphics.drawLine(0, halfh + 1, width, halfh + 1);
        graphics.drawLine(halfw, 0, halfw, height);
        graphics.drawLine(halfw + 1, 0, halfw + 1, height);
    }

    public void drawGrid(Graphics graphics) {
        String string;
        graphics.setColor(Color.lightGray);
        int n = 1;
        while (n < this.w + 1) {
            graphics.drawLine(halfw + 50 * n, 0, halfw + 50 * n, height);
            graphics.drawLine(halfw - 50 * n, 0, halfw - 50 * n, height);
            ++n;
        }
        int n2 = 1;
        while (n2 < this.h + 1) {
            graphics.drawLine(0, halfh + 50 * n2, width, halfh + 50 * n2);
            graphics.drawLine(0, halfh - 50 * n2, width, halfh - 50 * n2);
            ++n2;
        }
        graphics.setColor(Color.black);
        int n3 = 1;
        while (n3 < this.w + 1) {
            graphics.drawLine(halfw + 50 * n3, halfh, halfw + 50 * n3, halfh + 5);
            String string2 = new Double(xscale * (double)n3).toString();
            graphics.drawString(string2, halfw + 50 * n3 - 5, halfh + 15);
            graphics.drawLine(halfw - 50 * n3, halfh, halfw - 50 * n3, halfh + 5);
            string = new Double(-xscale * (double)n3).toString();
            graphics.drawString(string, halfw - 50 * n3 - 5, halfh + 15);
            ++n3;
        }
        graphics.setColor(Color.black);
        int n4 = 1;
        while (n4 < this.h + 1) {
            graphics.drawLine(halfw, halfh - 50 * n4, halfw - 5, halfh - 50 * n4);
            string = new Double(yscale * (double)n4).toString();
            graphics.drawString(string, halfw - 20, halfh - 50 * n4);
            graphics.drawLine(halfw, halfh + 50 * n4, halfw - 5, halfh + 50 * n4);
            String string3 = new Double(-yscale * (double)n4).toString();
            graphics.drawString(string3, halfw - 20, halfh + 50 * n4);
            ++n4;
        }
    }

    public void drawGraph(Graphics graphics) {
        int n;
        int n2 = halfw;
        int n3 = halfh;
        int n4 = halfw;
        int n5 = halfh;
        double d = 0.0;
        float f = Ix;
        float f2 = Iy;
        double d2 = 0.0;
        if (b != 0.0) {
            graphics.setColor(Color.blue);
            n = halfw;
            d2 = c / b;
            int n6 = halfh - (int)((double)f2 * d2 / yscale);
            n4 = n;
            n5 = n6;
            int n7 = 1;
            while (n7 < halfw) {
                n2 = n4;
                n3 = n5;
                d = xscale * (double)n7 / (double)f;
                n4 = halfw + n7;
                d2 = (c - a * d) / b;
                n5 = halfh - (int)((double)f2 * d2 / yscale);
                if (n5 < height && n5 > 0) {
                    graphics.drawLine(n2, n3, n4, n5);
                    graphics.drawLine(n2, n3 + 1, n4, n5 + 1);
                    graphics.drawLine(n2, n3 - 1, n4, n5 - 1);
                }
                ++n7;
            }
            n4 = n;
            n5 = n6;
            int n8 = -1;
            while (n8 > -halfw) {
                n2 = n4;
                n3 = n5;
                d = xscale * (double)n8 / (double)f;
                n4 = halfw + n8;
                d2 = (c - a * d) / b;
                n5 = halfh - (int)((double)f2 * d2 / yscale);
                if (n5 < height && n5 > 0) {
                    graphics.drawLine(n2, n3, n4, n5);
                    graphics.drawLine(n2, n3 + 1, n4, n5 + 1);
                    graphics.drawLine(n2, n3 - 1, n4, n5 - 1);
                }
                --n8;
            }
        }
        if (b == 0.0 & a != 0.0) {
            graphics.setColor(Color.blue);
            n = halfw;
            d = c / a;
            n4 = halfw + (int)((double)f * d / xscale);
            graphics.drawLine(n4, 0, n4, height);
            graphics.drawLine(n4 - 1, 0, n4 - 1, height);
            graphics.drawLine(n4 + 1, 0, n4 + 1, height);
        }
        graphics.setColor(Color.red);
        String string = new Double(this.xTrace).toString();
        String string2 = new Double(this.yTrace).toString();
        graphics.drawString("x=" + string, 20, 20);
        graphics.drawString("y=" + string2, 20, 40);
    }

    public void drawPoint(Graphics graphics) {
        if (a == 0.0 & b == 0.0) {
            return;
        }
        graphics.setColor(Color.red);
        graphics.fillOval(xpointA - 5, this.ypointA - 5, 10, 10);
        String string = new Double(this.xpointa).toString();
        String string2 = new Double(this.ypointa).toString();
        graphics.drawString("A(" + string + "," + string2 + ")", xpointA + 10, this.ypointA);
        graphics.fillOval(xpointB - 5, this.ypointB - 5, 10, 10);
        string = new Double(this.xpointb).toString();
        string2 = new Double(this.ypointb).toString();
        graphics.drawString("B(" + string + "," + string2 + ")", xpointB + 10, this.ypointB);
        double d = this.findSlope(this.xpointa, this.ypointa, this.xpointb, this.ypointb);
        String string3 = new Double(d).toString();
        if (d == Double.POSITIVE_INFINITY | d == Double.NEGATIVE_INFINITY) {
            string3 = "undefined";
        }
        WestPanel.tm.setText("slope= " + string3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = Math.abs(xpointA - mouseEvent.getX());
        int n2 = Math.abs(xpointB - mouseEvent.getX());
        if (b != 0.0) {
            if (n < n2) {
                xpointA = mouseEvent.getX();
            }
            if (n > n2) {
                xpointB = mouseEvent.getX();
            }
            PlotFrame.plotPanel.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        if (xpointA - 20 < n & n < xpointA + 20 & (this.ypointA - 20 < n2 & n2 < this.ypointA + 20)) {
            double d;
            String string;
            bl = true;
            if (b == 0.0) {
                this.xpointa = c / a;
                xpointA = halfw + (int)((double)Ix * this.xpointa / xscale);
                this.ypointA = n2;
                this.ypointa = (double)(halfh - this.ypointA) * yscale / (double)Iy;
            }
            if (b != 0.0) {
                if (a != 0.0) {
                    this.ypointA = n2;
                    this.ypointa = yscale * (double)(halfh - this.ypointA) / (double)Iy;
                    this.xpointa = (c - b * this.ypointa) / a;
                    xpointA = halfw + (int)((double)Ix * this.xpointa / xscale);
                }
                if (a == 0.0) {
                    this.ypointa = c / b;
                    this.ypointA = halfh - (int)((double)Iy * this.ypointa / yscale);
                    xpointA = n;
                    this.xpointa = xscale * (double)(xpointA - halfw) / (double)Ix;
                }
            }
            if ((string = new Double(d = this.findSlope(this.xpointa, this.ypointa, this.xpointb, this.ypointb)).toString()) == " -Infinity" | string == " Infinity" | string == " +Infinity") {
                string = "undefined";
            }
            WestPanel.tm.setText("slope= " + string);
            this.repaint();
            return;
        }
        if (xpointB - 20 < n & n < xpointB + 20 & (this.ypointB - 20 < n2 & n2 < this.ypointB + 20) && !bl) {
            if (b == 0.0) {
                this.xpointb = c / a;
                xpointB = halfw + (int)((double)Ix * this.xpointb / xscale);
                this.ypointB = n2;
                this.ypointb = (double)(halfh - this.ypointB) * yscale / (double)Iy;
            }
            if (b != 0.0) {
                if (a != 0.0) {
                    this.ypointB = n2;
                    this.ypointb = yscale * (double)(halfh - this.ypointB) / (double)Iy;
                    this.xpointb = (c - b * this.ypointb) / a;
                    xpointB = halfw + (int)((double)Ix * this.xpointb / xscale);
                }
                if (a == 0.0) {
                    this.ypointb = c / b;
                    this.ypointB = halfh - (int)((double)Iy * this.ypointb / yscale);
                    xpointB = n;
                    this.xpointb = xscale * (double)(xpointB - halfw) / (double)Ix;
                }
            }
            double d = this.findSlope(this.xpointa, this.ypointa, this.xpointb, this.ypointb);
            WestPanel.tm.setText(("slope= " + new Double(d)).toString());
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.xTrace = xscale * (double)(mouseEvent.getX() - halfw) / (double)Ix;
        this.yTrace = yscale * (double)(halfh - mouseEvent.getY()) / (double)Iy;
        this.repaint(10, 10, 80, 50);
    }

    public double findSlope(double d, double d2, double d3, double d4) {
        return (d4 - d2) / (d3 - d);
    }

    static {
        Ix = 50;
        Iy = 50;
        xscale = 1.0;
        yscale = 1.0;
        width = 502;
        height = 402;
        xpointA = 50 + width / 2;
        xpointB = -50 + width / 2;
    }
}

