/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;

class PlotPanel
extends Panel {
    static double a = 1.0;
    static double b = 1.0;
    static double c = 0.0;
    static double d = 0.0;
    static double Pi = Math.PI;
    double xTrace = 0.0;
    double yTrace = 0.0;
    int Ix = 50;
    int Iy = 50;
    static double xscale = 1.0;
    static double yscale = 1.0;
    private int width;
    private int height;
    private int halfw;
    private int halfh;
    Image image;
    static int flagPlotPoints = 0;
    static boolean flagClicks = true;
    int w;
    int h;

    public PlotPanel(int n, int n2) {
        this.width = 4 * n / 5;
        this.height = 4 * n2 / 6;
        this.halfw = this.width / 2;
        this.halfh = this.height / 2;
        this.setSize(this.width, this.height);
        this.setBackground(Color.white);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        this.image = this.createImage(this.width, this.height);
        Graphics graphics2 = this.image.getGraphics();
        this.drawAxis(graphics2);
        this.drawGrid(graphics2);
        this.drawGraph(graphics2);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void drawAxis(Graphics graphics) {
        this.width = this.width;
        this.height = this.height;
        this.halfw = this.width / 2;
        this.halfh = this.height / 2;
        this.w = this.halfw / 50;
        this.h = this.halfh / 50;
        graphics.setColor(new Color(215, 250, 255));
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, this.width, 0);
        graphics.drawLine(1, 1, this.width - 1, 1);
        graphics.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
        graphics.drawLine(this.width, 0, this.width, this.height);
        graphics.drawLine(this.width, this.height, 0, this.height);
        graphics.drawLine(this.width - 1, this.height - 1, 1, this.height - 1);
        graphics.drawLine(0, this.height, 0, 0);
        graphics.drawLine(1, this.height - 1, 1, 1);
        graphics.drawLine(0, this.halfh, this.width, this.halfh);
        graphics.drawLine(0, this.halfh + 1, this.width, this.halfh + 1);
        graphics.drawLine(this.halfw, 0, this.halfw, this.height);
        graphics.drawLine(this.halfw + 1, 0, this.halfw + 1, this.height);
    }

    public void drawGrid(Graphics graphics) {
        String string;
        graphics.setColor(Color.lightGray);
        int n = 1;
        while (n < this.w + 1) {
            graphics.drawLine(this.halfw + 50 * n, 0, this.halfw + 50 * n, this.height);
            graphics.drawLine(this.halfw - 50 * n, 0, this.halfw - 50 * n, this.height);
            ++n;
        }
        int n2 = 1;
        while (n2 < this.h + 1) {
            graphics.drawLine(0, this.halfh + 50 * n2, this.width, this.halfh + 50 * n2);
            graphics.drawLine(0, this.halfh - 50 * n2, this.width, this.halfh - 50 * n2);
            ++n2;
        }
        graphics.setColor(Color.black);
        int n3 = 1;
        while (n3 < this.w + 1) {
            graphics.drawLine(this.halfw + 50 * n3, this.halfh, this.halfw + 50 * n3, this.halfh + 5);
            String string2 = new Double(xscale * (double)n3).toString();
            graphics.drawString(string2, this.halfw + 50 * n3 - 5, this.halfh + 15);
            graphics.drawLine(this.halfw - 50 * n3, this.halfh, this.halfw - 50 * n3, this.halfh + 5);
            string = new Double(-xscale * (double)n3).toString();
            graphics.drawString(string, this.halfw - 50 * n3 - 5, this.halfh + 15);
            ++n3;
        }
        graphics.setColor(Color.black);
        int n4 = 1;
        while (n4 < this.h + 1) {
            graphics.drawLine(this.halfw, this.halfh - 50 * n4, this.halfw - 5, this.halfh - 50 * n4);
            string = new Double(yscale * (double)n4).toString();
            graphics.drawString(string, this.halfw - 20, this.halfh - 50 * n4);
            graphics.drawLine(this.halfw, this.halfh + 50 * n4, this.halfw - 5, this.halfh + 50 * n4);
            String string3 = new Double(-yscale * (double)n4).toString();
            graphics.drawString(string3, this.halfw - 20, this.halfh + 50 * n4);
            ++n4;
        }
    }

    public void drawGraph(Graphics graphics) {
        int n = this.halfw;
        int n2 = this.halfh;
        int n3 = this.halfw;
        int n4 = this.halfh;
        double d = 0.0;
        float f = this.Ix;
        float f2 = this.Iy;
        double d2 = 0.0;
        graphics.setColor(Color.red);
        int n5 = this.halfw;
        int n6 = this.halfh - (int)((double)f2 * PlotPanel.d / yscale);
        n3 = n5;
        n4 = n6;
        int n7 = 1;
        while (n7 < this.halfw) {
            n = n3;
            n2 = n4;
            d = xscale * (double)n7 / (double)f;
            n3 = this.halfw + n7;
            d2 = -a * d / b;
            n4 = this.halfh - (int)((double)f2 * (a * Math.sin(b * d) + PlotPanel.d) / yscale);
            if (n4 < this.height && n4 > 0) {
                graphics.drawLine(n, n2, n3, n4);
                graphics.drawLine(n, n2 + 1, n3, n4 + 1);
                graphics.drawLine(n, n2 - 1, n3, n4 - 1);
            }
            ++n7;
        }
        n3 = n5;
        n4 = n6;
        int n8 = -1;
        while (n8 > -this.halfw) {
            n = n3;
            n2 = n4;
            d = xscale * (double)n8 / (double)f;
            n3 = this.halfw + n8;
            d2 = -a * d / b;
            n4 = this.halfh - (int)((double)f2 * (a * Math.sin(b * d) + PlotPanel.d) / yscale);
            if (n4 < this.height && n4 > 0) {
                graphics.drawLine(n, n2, n3, n4);
                graphics.drawLine(n, n2 + 1, n3, n4 + 1);
                graphics.drawLine(n, n2 - 1, n3, n4 - 1);
            }
            --n8;
        }
        graphics.setColor(Color.blue);
        n5 = this.halfw;
        n6 = this.halfh - (int)((double)f2 * (a * Math.sin(c) + PlotPanel.d) / yscale);
        n3 = n5;
        n4 = n6;
        int n9 = 1;
        while (n9 < this.halfw) {
            n = n3;
            n2 = n4;
            d = xscale * (double)n9 / (double)f;
            n3 = this.halfw + n9;
            d2 = (c - a * d) / b;
            n4 = this.halfh - (int)((double)f2 * (a * Math.sin(b * d + c) + PlotPanel.d) / yscale);
            if (n4 < this.height && n4 > 0) {
                graphics.drawLine(n, n2, n3, n4);
                graphics.drawLine(n, n2 + 1, n3, n4 + 1);
                graphics.drawLine(n, n2 - 1, n3, n4 - 1);
            }
            ++n9;
        }
        n3 = n5;
        n4 = n6;
        int n10 = -1;
        while (n10 > -this.halfw) {
            n = n3;
            n2 = n4;
            d = xscale * (double)n10 / (double)f;
            n3 = this.halfw + n10;
            d2 = (c - a * d) / b;
            n4 = this.halfh - (int)((double)f2 * (a * Math.sin(b * d + c) + PlotPanel.d) / yscale);
            if (n4 < this.height && n4 > 0) {
                graphics.drawLine(n, n2, n3, n4);
                graphics.drawLine(n, n2 + 1, n3, n4 + 1);
                graphics.drawLine(n, n2 - 1, n3, n4 - 1);
            }
            --n10;
        }
    }
}

